/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      

      

      

      

      

      

      

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
          		  transformarTexto = true; // Cambiar a false, si la actividad es de lenguaje o requiere validación exacta de las palabras   
          		  eliminarEspacios = false; // Cambiar a true, si la actividad es de matemáticas o requiere omitir los espacios en blanco de la validación
          		  //Total de inputs       
                  TotalInput = 4;
                  //Para filtrar se pueden usar las siguientes variables:
               /* 
              'int':     /[\d]/,
              'float':     /[\d\.]/,
              'money':    /[\d\.\s,]/,
              'num':      /[\d\-\.]/,
              'hex':      /[0-9a-f]/i,
              'email':    /[a-z0-9_\.\-@]/i,
              'alpha':    /[a-zA-Z_ ]/i,
              'alphaupper': /[A-Z_ ]/i,
              'alphanum': /[a-z0-9_]/i,
              'alphanumlower':/[a-z0-9_]/,
              'alphanumupper':/[a-z0-9_]/,	
              'alphaspace':    /[a-z ]/i,
              'alphanumspace': /[a-z0-9_ ]/i,
              'alphanumspacelower':/[a-z0-9_ ],
              'mathsym':'[+-=\/*]/,
              'alphaacent':'[a-zA-Z_áéíóúü ]',
              'alphanumacent':'[a-z0-9_.áéíóúü ]'
          		*/
          
                  	sym.setVariable("border", "2px double #cccccc");		// Modifica el borde del input
          			sym.setVariable("fondo", "rgba(255,255,255,0.5)");	// Modifica el color de fondo del input
          			sym.setVariable("colorini", "#666666");					// Editar el color de la letra 
          			sym.setVariable("colorok", "#666666");
          			sym.setVariable("fondook","rgba(169,194,88,0.80)");
          			sym.setVariable("colorbad", "#ffffff");
          			sym.setVariable("fondobad", "#f3716c");
          			sym.setVariable("fontsize", "26px");						// Editar el tamaño de fuente
          			sym.setVariable("fontFamily", "Cabin");					//	Editar el tipo de fuente
          			sym.setVariable("fontStyle", "normal");				
          			sym.setVariable("fontweight", "bold");
          			sym.setVariable("height", "auto");
          			sym.setVariable("border-radius", "5px");
          			sym.setVariable("alineacionTexto", "center");			// Editar la alineación del texto en el input
          
          			//RESPUESTAS -- CAMBIAR VALORES
                  sym.setVariable("Respuesta_1", "1");
                  sym.setVariable("Respuesta_2", "500");
                  sym.setVariable("Respuesta_3", "1000");
                  sym.setVariable("Respuesta_4", "1000000");
                  sym.setVariable("Respuesta_5", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_6", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_7", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_8", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_9", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_10", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_11", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_12", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_13", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_14", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_15", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_16", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_17", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_18", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_19", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_20", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_21", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_22", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_23", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_24", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_25", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_26", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_27", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_28", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_29", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_30", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_31", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_32", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_33", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_34", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_35", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_36", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_37", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_38", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_39", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_40", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_41", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_42", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_43", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_44", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_45", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_46", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_47", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_48", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_49", "REEMPLAZAR POR VALOR");
                  sym.setVariable("Respuesta_50", "REEMPLAZAR POR VALOR");
                  
                  //	Copiar la siguiente función para las correcciones del material anterior
          //	Esta función permite que los elementos no se solapen
          
          // Se establece el atributo vacio para todos los elementos droppables
          sym.$('[id^="Stage_Drop_"]').attr("dragelement","vacio");
          
          		 $(".ui-droppable").on( "drop", function( event, ui ) {
          		 	// Verifico el estado del drop (ocupado o vacio)
          					var estadoDrop = $(this).attr("dragelement");
          
          					// 
          					if(estadoDrop != "vacio"){										
          						var numDrag = estadoDrop.slice(11);	
          						var posLeftDrag = sym.getVariable("left"+numDrag);
          						var posTopDrag = sym.getVariable("top"+numDrag);
          						sym.$("#"+estadoDrop).animate({top: posTopDrag, left: posLeftDrag});
          						var idDraggable = ui.draggable.attr('id');
          						$(this).attr("dragelement",idDraggable);
          					} else{
          						var idDraggable = ui.draggable.attr('id');
          						$(this).attr("dragelement",idDraggable);
          					}
          
          		 } );
          
          		 $(".ui-droppable").droppable({	
          				out: function( event, ui ){ 
          					var estadoDrop = $(this).attr("dragelement");
          					var idDraggable = ui.draggable.attr('id');
          					if(estadoDrop == idDraggable ){	
          						$(this).attr("dragelement","vacio");					
          					}
          					else{						
          					}
          				}
          		 });
          

      });
      //Edge binding end

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$('.center-wrapper').css("overflow","hidden");
         
         //Variables de colores
         sym.setVariable("fondo", "rgba(200,200,200,0.0)");
         sym.setVariable("colorbad", "rgba(50,230,60,0.4)");
         sym.setVariable("fondobad", "rgba(231,50,60,0.4)");
         sym.setVariable("fondook", "rgba(50,230,60,0.4)");
         sym.setVariable("fondoini", "rgba(244,244,244,0)");
         
         //Cambiar por la cantidad de elementos arrastrables
         TotalDragElements = 4;
         
         //Cambiar por la cantidad de elementos droppables o de destino
         TotalDropElements = 1;
         
         // Determino las respuestas correctas para cada drop en la actividad
         var dontTouch = 0;
         var Rd1 = new Array(1,dontTouch); 
         sym.setVariable("RespDrop1", Rd1);
         var Rd2 = new Array(2,3,dontTouch); 
         sym.setVariable("RespDrop2", Rd2);
         var Rd3 = new Array(3,dontTouch); 
         sym.setVariable("RespDrop3", Rd3);
         var Rd4 = new Array(4,dontTouch); 
         sym.setVariable("RespDrop4", Rd4);
         var Rd5 = new Array(5,dontTouch); 
         sym.setVariable("RespDrop5", Rd5);
         var Rd6 = new Array(6,dontTouch); 
         sym.setVariable("RespDrop6", Rd6);
         var Rd7 = new Array(7,dontTouch); 
         sym.setVariable("RespDrop7", Rd7);
         var Rd8 = new Array(8,dontTouch); 
         sym.setVariable("RespDrop8", Rd8);
         var Rd9 = new Array(9,dontTouch); 
         sym.setVariable("RespDrop9", Rd9);
         var Rd10 = new Array(10,dontTouch); 
         sym.setVariable("RespDrop10", Rd10);
         
         // Funcion para verificar las respuestas de cada drop
         function verificarRespuestas(RespuestaDrop,idActiveDrag){
         	var respDrop=0;
         
         	var idResp = idActiveDrag.slice(11);	
         	var vectorResp = sym.getVariable(RespuestaDrop);	
         	var respTemp = vectorResp.indexOf(parseInt(idResp));
         	if(respTemp != -1){
         		respDrop = 1;
         	}
         	else{
         		respDrop = 0;		
         	}	
         	return respDrop;	
         }
         
         for(var i=1; i<=TotalDragElements; i++){
         	sym.setVariable("left"+i, sym.$("Drag_"+i).css("left"));
         	sym.setVariable("top"+i, sym.$("Drag_"+i).css("top"));
         }
         
         for(var i=1; i<=50; i++){
            sym.setVariable("DropVar"+i, 0); 
         }
         
         function matrixToArray(matrix) {
             var scaleVars = matrix.substr(7, matrix.length - 8).split(', ');
             return scaleVars[0];
         }
         
         function calcularDimensiones(){
         	anchoDrag = parseInt($(this).width()/2);
         	altoDrag = parseInt($(this).height()/2);
         	console.log(anchoDrag);	
         	$(this).draggable({
         		cursorAt:{top: altoDrag, left: anchoDrag}
         	});
         }
         
         //Centrar el cursos en el elemento-cambiar por la mitad del ancho y alto
         //sym.$('[id^="Stage_Drag_"]').draggable({ cursorAt: { top: 20, left: 20 } });
         
          sym.$('[id^="Stage_Drag_"]').draggable({
         	//axis: ["x","y"], 
         	appendTo: "body",
         	containment: '#Stage', 
         	opacity: 0.4,
         	iframeFix: true,
         	zIndex: 100,
         	cursor:'move',		
         	refreshPositions: true,
         	//snap:true,
         	//snapMode: "both",
         	//snapTolerance:20,
         	scroll:false,
         	//helper: "clone",
         	revert: "invalid",
         	revertDuration: 500,
         
         	helper: function() {
         		var escalaTemp = $('#Stage').css('transform');
         		var escala = matrixToArray(escalaTemp);
               var helper = $(this).clone(); 
               helper.css({
             	"transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-ms-transform":"scale("+escala+")",
             	"-webkit-transform":"scale("+escala+")",
             	"-moz-transform":"scale("+escala+")",
             	"-o-transform":"scale("+escala+")",
             	"-moz-transform-origin":"left top",
         		"-webkit-transform-origin":"left top",
         		"-o-transform-origin":"left top",
         		"-ms-transform-origin":"left top",
             	});        
               return helper;
            }
         });
         
         
         
         
         	sym.$('[id^="Stage_Drop_"]').droppable({
         		drop: function( event, ui ){
         			var DropIdtemp=$(this).prop("id");	
         			var DropId = DropIdtemp.slice(11);	
         			var respDroppable=0;	 
         			var idDrag = ui.draggable.attr('id').slice(11);	
         			var DragActual = $("#"+DropIdtemp).children().prop("id");
         
         			if(typeof DragActual === 'undefined'){
            			$("#"+DropIdtemp).append(ui.draggable);   			
          			}
          			else{
          				var topDrag = sym.getVariable("top"+idDrag);
         				var leftDrag = sym.getVariable("left"+idDrag);
         				$("#Stage").append($("#"+DropIdtemp).children());
         				//$("#"+DropIdtemp).empty();
         				sym.$("Drag_"+i).css({top: topDrag, left: leftDrag});
         				$("#"+DropIdtemp).append(ui.draggable);
          			}
         			coordenadas("Drop_"+DropId, ui.draggable.attr('id').slice(6));	
         			$('[id^="Stage_peso_"]').hide();
         			switch(idDrag){				
         				case "1":	$("#Stage_peso_1").fadeIn("fast");
         				break;
         				case "2":	$("#Stage_peso_2").fadeIn("fast");
         				break;
         				case "3":	$("#Stage_peso_4").fadeIn("fast");
         				break;
         				case "4":	$("#Stage_peso_3").fadeIn("fast");
         				break;	
         			}			
         			$("#Stage").append(sym.$("resp_correcta"));
         			$("#Stage").append(sym.$("resp_incorrecta"));
         			$("#Stage").append(sym.$("help_input"));			
            	}
            });	
         
            function coordenadas (Drop, simbolo) {
                varxdrop = sym.$(Drop).css("left");
                varydrop = sym.$(Drop).css("top");
                varxdropanch = sym.$(Drop).css("width");
                varydropalto = sym.$(Drop).css("height");       
         
                varxdraganch = sym.$(simbolo).css("width");  
                varydragalto = sym.$(simbolo).css("height");
                varxdropcentro = ((parseInt(varxdropanch)/2) - (parseInt((parseInt(varxdraganch)/2))));
                varydropcentro = 2*((parseInt(varydropalto)/2) - (parseInt((parseInt(varydragalto)/2))));
         
                sym.$(simbolo).css({top: varydropcentro, left: varxdropcentro});
             };
         
         
         
         
         
         
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

})(jQuery, AdobeEdge, "EDGE-94063035");
 