var stageHeight = document.getElementById('Stage').height(); // Set a variable for the height of the stage

$("#Stage").css({ // Set the transform origin so we always scale to the top left corner of the stage
"transform-origin":"0 0",
"-ms-transform-origin":"0 0",
"-webkit-transform-origin":"0 0",
"-moz-transform-origin":"0 0",
"-o-transform-origin":"0 0"
});

function scaleStage() {
    var stage =  $('stage'); // Set a reusable variable to reference the stage
    var parent = $('stage').parent(); // Set a reusable variable to reference the parent container of the stage

    var parentWidth = stage.parent().width(); // Get the parent of the stage width
    var stageWidth = stage.width(); // Get the stage width
    var desiredWidth = Math.round(parentWidth * 1); // Set the new width of the stage as it scales
    var rescale = (desiredWidth / stageWidth); 

// Rescale the stage!
	 stage.css('transform', 'scale(' + rescale + ')'); 
    stage.css(  '-o-transform', 'scale(' + rescale + ')');
	 stage.css('-ms-transform', 'scale(' + rescale + ')');
    stage.css('-webkit-transform', 'scale(' + rescale + ')');
	 stage.css('-moz-transform', 'scale(' + rescale + ')');
    stage.css('-o-transform', 'scale(' + rescale + ')');
    parent.height(stageHeight * rescale); // Reset the height of the parent container so the objects below it will reflow as the height adjusts
}

// Make it happen when the browser resizes
$(window).on('resize', function(){ 
	 scaleStage(); 
});

// Make it happen when the page first loads
$(document).ready(function(){
    scaleStage();
});


