function init(){
    initDragDrop('.drag', '.drop');
    imgPopUp();
}

function pause(idVideo){ 
    $('#'+idVideo).trigger('pause'); 
}

function setMsgClick( msg ){
    msg =  typeof(msg) != 'undefined' ? msg:'para la ver la información';
    var htmlMsg =  'Haz <span class="icon click">clic</span> '+msg;
    $(".ggd_text_exp").html( htmlMsg);
}

function setMsgTitle(msgTitle){
    $(".ggd_title").html( msgTitle);
}


function removeAccent(str){
    var map={'À':'A','Á':'A','Â':'A','Ã':'A','Ä':'A','Å':'A','Æ':'AE','Ç':'C','È':'E','É':'E','Ê':'E','Ë':'E','Ì':'I','Í':'I','Î':'I','Ï':'I','Ð':'D','Ñ':'N','Ò':'O','Ó':'O','Ô':'O','Õ':'O','Ö':'O','Ø':'O','Ù':'U','Ú':'U','Û':'U','Ü':'U','Ý':'Y','ß':'s','à':'a','á':'a','â':'a','ã':'a','ä':'a','å':'a','æ':'ae','ç':'c','è':'e','é':'e','ê':'e','ë':'e','ì':'i','í':'i','î':'i','ï':'i','ñ':'n','ò':'o','ó':'o','ô':'o','õ':'o','ö':'o','ø':'o','ù':'u','ú':'u','û':'u','ü':'u','ý':'y','ÿ':'y','Ā':'A','ā':'a','Ă':'A','ă':'a','Ą':'A','ą':'a','Ć':'C','ć':'c','Ĉ':'C','ĉ':'c','Ċ':'C','ċ':'c','Č':'C','č':'c','Ď':'D','ď':'d','Đ':'D','đ':'d','Ē':'E','ē':'e','Ĕ':'E','ĕ':'e','Ė':'E','ė':'e','Ę':'E','ę':'e','Ě':'E','ě':'e','Ĝ':'G','ĝ':'g','Ğ':'G','ğ':'g','Ġ':'G','ġ':'g','Ģ':'G','ģ':'g','Ĥ':'H','ĥ':'h','Ħ':'H','ħ':'h','Ĩ':'I','ĩ':'i','Ī':'I','ī':'i','Ĭ':'I','ĭ':'i','Į':'I','į':'i','İ':'I','ı':'i','Ĳ':'IJ','ĳ':'ij','Ĵ':'J','ĵ':'j','Ķ':'K','ķ':'k','Ĺ':'L','ĺ':'l','Ļ':'L','ļ':'l','Ľ':'L','ľ':'l','Ŀ':'L','ŀ':'l','Ł':'L','ł':'l','Ń':'N','ń':'n','Ņ':'N','ņ':'n','Ň':'N','ň':'n','ŉ':'n','Ō':'O','ō':'o','Ŏ':'O','ŏ':'o','Ő':'O','ő':'o','Œ':'OE','œ':'oe','Ŕ':'R','ŕ':'r','Ŗ':'R','ŗ':'r','Ř':'R','ř':'r','Ś':'S','ś':'s','Ŝ':'S','ŝ':'s','Ş':'S','ş':'s','Š':'S','š':'s','Ţ':'T','ţ':'t','Ť':'T','ť':'t','Ŧ':'T','ŧ':'t','Ũ':'U','ũ':'u','Ū':'U','ū':'u','Ŭ':'U','ŭ':'u','Ů':'U','ů':'u','Ű':'U','ű':'u','Ų':'U','ų':'u','Ŵ':'W','ŵ':'w','Ŷ':'Y','ŷ':'y','Ÿ':'Y','Ź':'Z','ź':'z','Ż':'Z','ż':'z','Ž':'Z','ž':'z','ſ':'s','ƒ':'f','Ơ':'O','ơ':'o','Ư':'U','ư':'u','Ǎ':'A','ǎ':'a','Ǐ':'I','ǐ':'i','Ǒ':'O','ǒ':'o','Ǔ':'U','ǔ':'u','Ǖ':'U','ǖ':'u','Ǘ':'U','ǘ':'u','Ǚ':'U','ǚ':'u','Ǜ':'U','ǜ':'u','Ǻ':'A','ǻ':'a','Ǽ':'AE','ǽ':'ae','Ǿ':'O','ǿ':'o'};
    var res='';
     for (var i=0;i<str.length;i++){c=str.charAt(i);res+=map[c]||c;}return res; 
}

function validarEjercicioInputs(){

    var correct=['energia', 'longitud de onda', 'radiacion ionizante','radiacion no ionizante', 'frecuencia'];
    var $i=0;
    var errorsForm=0; 

    $("#ejercicio1 textarea").each(function() {
        val = removeAccent(this.value.toLowerCase());

        if (val == correct[$i]){
            this.style.backgroundColor = "rgb(240, 237, 171)";
        }
        else{
            this.style.backgroundColor = "rgb(255, 214, 213)";
            this.value= '';
            errorsForm ++;
        }
        $i++;
    });

    if(errorsForm>0) {
        sg.sound('error');
    }
    else{
        sg.sound('success-low');
    } 

}


//  Carlos U
//  Meta boton 
// CALL AFTER INIT
function metaBoton(idContainer){

    //Config 
    var BOTON_MARGIN_TOP= 20;
    var CENTER_TEXT  = true; // CENTER all OR Put in FRONT

    var container = $('#'+idContainer);
    var containerPos= container.offset();
    var buttons = container.find('div[btkey]');
    var BOTON_WIDTH_EXTRA = container.width()*0.05; // 5 % of container 
    var BOTON_WIDTH = container.width()*0.35; // 35% of container
    var vCenter =  container.height() / 2;

    buttons.each(function (i){
        // identificador del tag boton
        botonKey = $(this).attr('btkey'); 
        botonWidth = $(this).width();
        botonHeight = $(this).outerHeight() + BOTON_MARGIN_TOP;
        botonColorFondo = $(this).css('background-color');
        botonTopPos = i * botonHeight;
        $(this).css('top', botonTopPos );  // Set vertical pos of button

        // reset Positions and width 
        $('div[btkey]').css( 'width', BOTON_WIDTH);
        // reset position 
        $('div[txtkey]').css({ 'left': 0, 'visibility' :  'hidden'});

        //Texto asociado del boton y su re-posicion
        txtBoton =  $('div[txtkey="' + botonKey + '"]');
        txtHeight = txtBoton.outerHeight();


        //console.log('vcenter :'+ vCenter );
        //console.log('top :'+ botonTopPos );
        //console.log('txt :'+ txtBoton.length );

        if( CENTER_TEXT ){
                txtBoton.css({'top': 0,  'border-color': botonColorFondo });
        }else{ // Put corner in front of button

            if ( ( botonTopPos + botonHeight/2) < vCenter){  //   From Top to boottom
                //console.log('down');
                txtBoton.css({'top': botonTopPos,  'border-color': botonColorFondo });
            }
            else{  
                //console.log('up');
                txtBoton.css({'top': ( botonTopPos - txtHeight + botonHeight/2 ),  'border-color': botonColorFondo });
            }

        }
        $(this).click(function (){
            // reset Positions and width 
            $('div[txtkey]').css({ 'left': 0, 'visibility' :  'hidden'});
            $('div[txtkey]').removeClass('animated bounceInLeft');
            $('div[btkey]').css( 'width', BOTON_WIDTH);

            botonKey = $(this).attr('btkey'); 
            $(this).css('width', botonWidth + BOTON_WIDTH_EXTRA + 10); //overlap 10 pixels

            txtBoton =  $('div[txtkey="' + botonKey + '"]');
            txtBoton.css({'left': botonWidth + BOTON_WIDTH_EXTRA , 'visibility': 'visible'});  
            txtBoton.addClass('animated bounceInLeft');


        });

    });

}

//  Requires :
//  PopUp and Button PopUp  with id = 100
//  big custom attr on img 
//  _big   suffix on file image
function imgPopUp(){
    images = $('img[big]');
    var btPopUp = $('[data-sg-id="btn-popup"][data-sg-key="100"]');
    var popUp = $('[data-sg-id="item-popup"][data-sg-key="100"]');
    var MAX_WIDTH_IMG = 900;
    var MAX_HEIGHT_IMG = 550;
    var MAX_HEIGHT_POPUP = 765;
    var contAspectRatio = MAX_WIDTH_IMG / MAX_HEIGHT_IMG;


     images.each(function(){


         $(this).on('click', function(){
             var content=popUp.find('#imgContainer');
             content.html(''); //Clear any prev content
             var src = $(this).attr('src');
             var baseName =  src.substr(0, src.lastIndexOf('.')) || input;
             var fileExt = src.split('.').pop();
             var big = baseName+"_big."+fileExt;
             var imgContainer = $('<img id="imgContainer">'); 

             imgContainer.attr("src",big).load(function(){

                var width = this.width;
                var height = this.height;

                if(width > MAX_WIDTH_IMG){
                    ratio = MAX_WIDTH_IMG / width;        // get ratio for scaling image
                    $(this).css("width", MAX_WIDTH_IMG);  // Set new width
                    $(this).css("height", height * ratio);   // Scale height based on ratio
                    height = height * ratio;                 // Reset height to match scaled image
                    width = width * ratio;                   // Reset width to match scaled image
                }

                // Check if current height is larger than max
                if(height > MAX_HEIGHT_IMG){
                    ratio = MAX_HEIGHT_IMG / height; // get ratio for scaling image
                    $(this).css("height", MAX_HEIGHT_IMG);   // Set new height
                    $(this).css("width", width * ratio);    // Scale width based on ratio
                    width = width * ratio;    // Reset width to match scaled image
                }

                $(this).css({'display': 'block' , 'margin': 'auto'});

             imgContainer.appendTo(content);  // ADDS the magic!! 
             btPopUp.trigger('click'); // Activate pop up 
             sg.sound('success-low');

             }); // End Load

         });
     });
} // Fin Img Pop Up Carlos unescape
