// Drag - Drop on SG
// Carlos U

function  verificarSolucion(){

    console.log('Verificando..');

    $('.drag').draggable('disable');
    $('.drop').droppable('disable');
    $('.drag').addClass('disabled');

    $('.solucion').fadeIn();
}

function dragF(event, ui){

    // Apply  SG transform scale !!!!!!!
    var offset = ui.position;
    var xPos = offset.left/sg.scaleX;
    var yPos = offset.top/sg.scaleY ;
    ui.position = { 'top': yPos, 'left': xPos};

}

function acceptF(ui){
    var dropKey = $(this).attr('ddKey');
    var dragKey =ui.attr('ddKey');

    if( dropKey == dragKey )
    {
        return true;
    }

    return false;
}

function dropF(event, ui){
    var CUSTOM_CLONE = false; // bool
    var dropKey = $(this).attr('ddkey');
    var dragKey= $(ui.draggable).attr('ddkey');

    if(dragKey == dropKey) {

        ui.draggable.addClass( 'dropped' );      // Css  
        ui.draggable.data('dropkey',dropKey); // Associate the container
        $(this).droppable('disable');                       // Disable the drop
        ui.draggable.draggable('option', 'disabled', true); // Disable the drag
        ui.draggable.css('cursor','default');  //Reset mouse cursor

        if(CUSTOM_CLONE){
            var clone = $(ui.draggable).clone();
            $(clone).addClass('cloned');
            $(clone).css('position', 'absolute');
            $(this).append(clone);
            snapToMiddle($(clone), $(this));
            ui.draggable.find('img').addClass('grayFilterEnabled');
        }else{
            //$(this).append(ui.draggable.css('position','relative'));
            txtHtml = '<p class="round verde"  style="text-align: center; color: #fff; line-height: 30px;">'+ ui.draggable.find('.tagImagen').html() +"</p>";
            snapToMiddle($(ui.draggable), $(this));
            $(this).html(txtHtml);
            ui.draggable.parent().find('img').addClass('grayFilterEnabled');
            ui.draggable.addClass('disabled');
        }

        sg.sound('success-low');
    }
    else
    { 
        sg.sound('error');
    }

}

function initDragDrop(selectorDrag, selectorDrop) {
    console.log('Init');

    $(selectorDrag).draggable({
        //refreshPositions: true,
        drag: dragF,
        helper: 'clone',
        revertDuration: 400,

        containment: '#contenido',

        // snap: ".drop",   //Adhiere a borde de drop
        snapMode: "fit",
    });

    // Mouse drag cursor
    $(selectorDrag).css('cursor','pointer');

    $(selectorDrop).droppable({
        drop: dropF,
        //accept: acceptF,
        activeClass: 'boxshadow' // BOX SHADOW  CSS STYLE NEEDED 
    });

    // Keeep original drags position for reset
    preserveDragsPosition(selectorDrag);

}

// Funciones de apoyo 

function snapToMiddle(dragObj, target){

    var INCLUDE_MARGIN  = false;  // Include or ignore margin to calculate center 

    var topMove = (target.outerHeight(  INCLUDE_MARGIN  ) - dragObj.outerHeight(  INCLUDE_MARGIN  )) / 2;
    var leftMove= (target.outerWidth(  INCLUDE_MARGIN  ) - dragObj.outerWidth( INCLUDE_MARGIN )) / 2;

    dragObj.animate({top:topMove,left:leftMove},{duration:10,easing:'easeOutBack'});
}

function pause(idVideo){ 
    $('#'+idVideo).trigger('pause'); 
} 

//Preserve position to reset
function preserveDragsPosition(selectorDrag){

    var allDrags = $(selectorDrag);
    var offset;

    allDrags.each(function(){

        offset=$(this).position();

        $(this).data({
            'originalLeft': offset.left/sg.scaleX,
            'origionalTop': offset.top/sg.scaleY,
            'originalPosition': $(this).css('position'),
            'parentDiv': $(this).parent()

        });
    });

}

function resetDragDrop(selectorDrag, selectorDrop){

    var allDrags = $(selectorDrag).not('.cloned');
    var allDrops = $(selectorDrop);
    var dragClones = $(selectorDrag +'.cloned');

    dragClones.remove();

    // Restore postion of all drags needs same container TODO goback to previous parent -> DONE !!!!
    allDrags.each(function(){
        //$(this).appendTo($(this).data('parent')),
        $(this).appendTo($(this).data('parentDiv'));
        $(this).css({
            'left': $(this).data('originalLeft'),
            'top': $(this).data('origionalTop'),
            'position': $(this).data('originalPosition')
        });

        $(this).data('dropkey','');                     // Clear previuous data
        $(this).draggable('option', 'disabled', false); // Enable Drag
    });

    allDrops.droppable('enable');           // Enable drops
    allDrags.css('cursor','pointer');       // Restore Mouse cursor
    allDrags.find('img').removeClass('grayFilterEnabled');

}


// Drag - Drop on SG 
// Carlos U
