function init(){
    imgPopUp();
    cascade(1);
    cascade(2);
    cascade(3);
    initValidarFocus(1);

}

function pause(idVideo){ 
    $('#'+idVideo).trigger('pause'); 
}

function initValidarFocus(groupKey){
    var results =  [3,1,3,2];
    var inputs = $('input:text[groupkey='+groupKey+']');

    inputs.each(function(){
        $(this).focusout(function(){
            var keyValue= $(this).attr('keyvalue');
            var resultado = $('.resultado[groupkey='+groupKey+'][keyvalue='+keyValue+']');

           if( results[keyValue] == parseInt($(this).val())){
               sg.sound('success-low');
               resultado.addClass('bgAcierto');
               resultado.removeClass('bgError');
               $(this).prop('disabled','true');
           }
           else{
               if($(this).val()) {
                   sg.sound('error');
                   $(this).val('');
                   resultado.addClass('bgError');
                   resultado.removeClass('bgAcierto');
               }
               else{
                   resultado.removeClass('bgError');
                   resultado.removeClass('bgAcierto');
               }
           }
        });
    });
} //End validar focus

// Requires position absolute
// Uses  cascadeToggle  attribute to activate childs
// Requires Cascade  to group elements 
// <img id="grap1Part1" cascade="1" parent="0" cascadeToggle="1" class="" src="img/grapSeq1P1.png" alt=""/> 
function cascade(cascadeGroup){
   var elements = $('[cascade='+cascadeGroup+']');
   var firstGroup = $('[cascade='+cascadeGroup+'][parent=0]');
   var restGroup = $('[cascade='+cascadeGroup+'][parent!=0]');
   var toggleElements = $('[cascade='+cascadeGroup+'][cascadeToggle]');

    restGroup.hide(); // Leave only initial show elements  (parent =0)

    toggleElements.each(function(){
        $(this).on('click', function(){
            var keyToggle = $(this).attr('cascadeToggle');
            var childs = $('[cascade='+cascadeGroup+'][parent='+keyToggle+']');
            childs.toggle("fold");
            $(this).unbind('click');
            sg.sound('success-low');
        })

    })
}

//  Requires :
//  PopUp and Button PopUp  with id = 100
//  big custom attr on img 
//  _big   suffix on file image
function imgPopUp(){
    images = $('img[big]');
    var btPopUp = $('[data-sg-id="btn-popup"][data-sg-key="100"]');
    var popUp = $('[data-sg-id="item-popup"][data-sg-key="100"]');
    var MAX_WIDTH_IMG = 900;
    var MAX_HEIGHT_IMG = 550;
    var MAX_HEIGHT_POPUP = 765;
    var contAspectRatio = MAX_WIDTH_IMG / MAX_HEIGHT_IMG;


     images.each(function(){


         $(this).on('click', function(){
             var content=popUp.find('#imgContainer');
             content.html(''); //Clear any prev content
             var src = $(this).attr('src');
             var baseName =  src.substr(0, src.lastIndexOf('.')) || input;
             var fileExt = src.split('.').pop();
             var big = baseName+"_big."+fileExt;
             var imgContainer = $('<img id="imgContainer">'); 

             imgContainer.attr("src",big).load(function(){

                var width = this.width;
                var height = this.height;

                if(width > MAX_WIDTH_IMG){
                    ratio = MAX_WIDTH_IMG / width;        // get ratio for scaling image
                    $(this).css("width", MAX_WIDTH_IMG);  // Set new width
                    $(this).css("height", height * ratio);   // Scale height based on ratio
                    height = height * ratio;                 // Reset height to match scaled image
                    width = width * ratio;                   // Reset width to match scaled image
                }

                // Check if current height is larger than max
                if(height > MAX_HEIGHT_IMG){
                    ratio = MAX_HEIGHT_IMG / height; // get ratio for scaling image
                    $(this).css("height", MAX_HEIGHT_IMG);   // Set new height
                    $(this).css("width", width * ratio);    // Scale width based on ratio
                    width = width * ratio;    // Reset width to match scaled image
                }

                $(this).css({'display': 'block' , 'margin': 'auto'});

             imgContainer.appendTo(content);  // ADDS the magic!! 
             btPopUp.trigger('click'); // Activate pop up 

             }); // End Load

         });
     });
} // Fin Img Pop Up Carlos U



