function init(){

    pulseButtons('.btCircle');
    initDragDrop('.drag','.drop, .drop2');
    cascade(1, '#gridGraph1');
    cascade(2, '#gridGraph2');
    cascade(3, '#gridGraph3');

    initValidarRadios(1);
    initValidarRadios(2);
    initValidarRadios(3);
    initValidarRadios(4);
    initValidarRadios(5);
    initValidarRadios(6);
    initValidarRadios(7);

    magicAnimate(1);
    imgPopUp();
}

function setMsgTitle(msgTitle){
    $(".ggd_title").html( msgTitle);
}

function setMsgClick( msg ){
    msg =  typeof(msg) != 'undefined' ? msg:'para ver la información';
    var htmlMsg =  'Haz <span class="icon click">clic</span> '+msg;
    $(".ggd_text_exp").html( htmlMsg);
}

function showElement(idElement){
    var element = $(idElement);
    var groupId = $(idElement).attr('groupElement');
    var groupElements =  $('[groupelement='+groupId+']');

    groupElements.css('display','none');
    element.toggle('clip');
    sg.sound('success-low');
}

function pulseButtons(selector){
    $(selector).addClass('animated  infinite pulse');
}

// Validate a radio group
// Requiere style for bgAcierto, bgError and Resultado html tag
function initValidarRadios( groupName ){
    allRadios = $(':radio[name='+groupName+']');
    allRadios.each(function(){
        $(this).change(function(){
            var keyValue= $(this).attr('keyvalue'); // Id of pair elements radio - resultado
            var resultado = $('.resultado[radioname='+groupName+'][keyvalue='+keyValue+']');

            $('.resultado[radioname='+groupName+']').removeClass('bgError'); //Reset previous errors

            if($(this).val() == "1"){
                sg.sound('success');
                group = $(':radio[name='+$(this).attr("name")+']');
                group.prop('disabled',true);

                resultado.addClass('bgAcierto');
                resultado.removeClass('bgError');
                $(this).prop('disabled','true');
            }
            else{
                sg.sound('error');
                resultado.addClass('bgError');
                resultado.removeClass('bgAcierto');
            }
        });

    });
}


// Requires position absolute
// Uses  cascadeToggle  attribute to activate childs
// Requires Cascade  to group elements 
// <img id="grap1Part1" cascade="1" parent="0" cascadeToggle="1" class="" src="img/grapSeq1P1.png" alt=""/> 
function cascade(cascadeGroup, container){
   var elements = $('[cascade='+cascadeGroup+']');
   var firstGroup = $('[cascade='+cascadeGroup+'][parent=0]');
   var restGroup = $('[cascade='+cascadeGroup+'][parent!=0]');
   var toggleElements = $('[cascade='+cascadeGroup+'][cascadeToggle]');

    restGroup.hide(); // Leave only initial show elements  (parent =0)

    toggleElements.each(function(){
        $(this).on('click', function(){
            var keyToggle = $(this).attr('cascadeToggle');
            var childs = $('[cascade='+cascadeGroup+'][parent='+keyToggle+']');
            childs.toggle("fold");
            $(this).unbind('click');
            sg.sound('success-low');

            var contenedorGraph = $(container);
            contenedorGraph.scrollTop(contenedorGraph.prop("scrollHeight"));
        });

    });
}

// Requires  Animate.css
// Author Carlos U
// <tag1 magicGroup="x" ... <tag2 magicGroup="1" magicEffect="zoomInUp"
function magicAnimate(groupSequence){
    var DEFAULT_EFFECT = 'bounceInRight';

    groupSequence  = (typeof groupSequence === "undefined") ? 1 : groupSequence;
    elements = $('[magicGroup="' + groupSequence + '"]');

    elements.each(function(i){
        attrEffect = $(this).attr('magicEffect');
        effect = (typeof attrEffect === "undefined" || attrEffect ==='') ? DEFAULT_EFFECT : attrEffect;
        $(this).addClass('animated '+ effect);
        $(this).css('visibility','visible');
    });
}

//  Requires :
//  PopUp and Button PopUp  with id = 100
//  big custom attr on img 
//  _big   suffix on file image
function imgPopUp(){
    images = $('img[big]');
    var btPopUp = $('[data-sg-id="btn-popup"][data-sg-key="100"]');
    var popUp = $('[data-sg-id="item-popup"][data-sg-key="100"]');
    var MAX_WIDTH_IMG = 900;
    var MAX_HEIGHT_IMG = 550;
    var MAX_HEIGHT_POPUP = 765;
    var contAspectRatio = MAX_WIDTH_IMG / MAX_HEIGHT_IMG;


     images.each(function(){


         $(this).on('click', function(){
             var content=popUp.find('#imgContainer');
             content.html(''); //Clear any prev content
             var src = $(this).attr('src');
             var baseName =  src.substr(0, src.lastIndexOf('.')) || input;
             var fileExt = src.split('.').pop();
             var big = baseName+"_big."+fileExt;
             var imgContainer = $('<img id="imgContainer">'); 

             imgContainer.attr("src",big).load(function(){

                var width = this.width;
                var height = this.height;

                if(width > MAX_WIDTH_IMG){
                    ratio = MAX_WIDTH_IMG / width;        // get ratio for scaling image
                    $(this).css("width", MAX_WIDTH_IMG);  // Set new width
                    $(this).css("height", height * ratio);   // Scale height based on ratio
                    height = height * ratio;                 // Reset height to match scaled image
                    width = width * ratio;                   // Reset width to match scaled image
                }

                // Check if current height is larger than max
                if(height > MAX_HEIGHT_IMG){
                    ratio = MAX_HEIGHT_IMG / height; // get ratio for scaling image
                    $(this).css("height", MAX_HEIGHT_IMG);   // Set new height
                    $(this).css("width", width * ratio);    // Scale width based on ratio
                    width = width * ratio;    // Reset width to match scaled image
                }

                $(this).css({'display': 'block' , 'margin': 'auto'});

             imgContainer.appendTo(content);  // ADDS the magic!! 
             btPopUp.trigger('click'); // Activate pop up 

             }); // End Load

         });
     });
} // Fin Img Pop Up Carlos U
