var initList = initList || [];
initList.push(function() {

    $('.names').find('.item').each(function(index, value) {
      var dropSelector= $(value).attr('data-sg-drop-selector');
      sg.setDraggable($(value), {
        revert: true,
        dropSelector:dropSelector,
        success: function() {
            
            var $this = $(this);
            var drop = $this.data("hit").eq(0);                    

            $this.attr( "data-sg-selected", ("#" + drop.attr("id")) );
            drop.attr("id", (drop.attr("id")+"_fill") );

            var boton = $(".btnCheck");
            var attempts = parseInt(boton.attr("data-sg-count")) + 1;
            boton.attr("data-sg-count", attempts);
            if (attempts == 5) {
                boton.bind("click", revisar).addClass("ready");
                boton.css('cursor','pointer');
            }
            sg.sound('success');
        },
        fail: function() {
        }
      });
    });


    function revisar(){
        var boton = $(".btnCheck");
        var num_corrects = 0;

        $('.ui-draggable-dragging').each(function() {
            $this = $(this);
            var correct = $this.attr("data-sg-correct");
            var selected = $this.attr("data-sg-selected");
            
            if (correct == selected){
                $this.addClass("correct");
                num_corrects++;    
            }else{
                var elem_selected = $(selected+"_fill");
                var new_id = selected.substr(1,5);
                elem_selected.text("").attr("id",new_id);

                var id_drag = "#"+ $this.attr("id");
                $(id_drag).css("visibility","visible");
                $this.css("display", "none").remove();
                var attempts = parseInt(boton.attr("data-sg-count")) - 1;
                boton.attr("data-sg-count", attempts).removeClass("ready").unbind("click", revisar);
                boton.css('cursor','default');
            }
        });

        if (num_corrects == 5)
        {
            boton.html("<img src='./img/correcto.png'>");
            boton.unbind("click", revisar);
            boton.css('cursor','default');
        }
            
            
    }
    
    $('[data-sg-id=elem-tab]')
    .bind("easytabs:before", function(e, $targetPanel, settings){
        /*Delete all _fill to allow restart the draggable element*/
        $("div[id$='_fill']").each(function(index, value){
            var $this = $(this);
            var attrId = $this.attr('id').substr(0,5);
            $this.attr("id",attrId);
        });
        $('.btnCheck').attr('data-sg-count',0).removeClass('completed').removeClass('ready').html('<img src="./img/botones1.png">');

    }).easytabs();

});