// A javascript-enhanced crossword puzzle [c] Jesse Weisbeck, MIT/GPL 


var initList = initList || []; 

initList.push(function(){
(function($) {
	$(function() {
		// provide crossword entries in an array of objects like the following example
		// Position refers to the numerical order of an entry. Each position can have 
		// two entries: an across entry and a down entry
		var puzzleData = [
			 	{
					clue: "Línea que une las diferentes posiciones del recorrido de un objeto.",
					answer: "TRAYECTORIA",
					position: 0,
					paintPos:1,
					orientation: "across",
					startx: 4,
					starty: 1
				},
			 	{
					clue: "Posición final menos posición inicial.",
					answer: "DESPLAZAMIENTO",
					position: 1,
					paintPos:2,
					orientation: "across",
					startx: 2,
					starty: 4
				},
				{
					clue: "Curva de la gráfica de posición vs tiempo del movimiento rectilíneo uniforme de un objeto.",
					answer: "RECTA",
					position: 2,
					paintPos:3,
					orientation: "across",
					startx: 6,
					starty: 6
				},
				{
					clue: "Cociente entre el desplazamiento y el tiempo.",
					answer: "VELOCIDAD",
					position: 3,
					paintPos:4,
					orientation: "across",
					startx: 3,
					starty: 9
				},
				{
					clue: "Caída vertical de los cuerpos en la que no se tiene en cuenta el rozamiento del objeto con el aire.",
					answer: "LIBRE",
					position: 4,
					paintPos:5,
					orientation: "across",	
					startx: 11,
					starty: 11
				},
				{
					clue: "Trayectoria de los proyectiles",
					answer: "PARABOLA",
					position: 5,
					paintPos:6,
					orientation: "across",
					startx: 2,
					starty: 12
				},
				{
					clue: "Aceleración generada por el cambio en la dirección de la velocidad.",
					answer: "CENTRIPETA",
					position: 6,
					paintPos:7,
					orientation: "across",
					startx: 4,
					starty: 14
				},
				{
					clue: "Movimiento con velocidad constante.",
					answer: "UNIFORME",
					position: 7,
					paintPos: 8,
					orientation: "across",
					startx: 3,
					starty: 17
				},

				// DOWN -------------------
				{
					clue: "Cociente entre el cambio de velocidad y el tiempo",
					answer: "ACELERACION",
					position: 8,
					paintPos:1,
					orientation: "down",
					startx: 4,
					starty: 6
				},
				{
					clue: "Movimiento con velocidad variable.",
					answer: "ACELERADO",
					position: 9,
					paintPos:2,
					orientation: "down",
					startx: 6,
					starty: 1
				},
				{
					clue: "Aceleración con valor aproximado de 9,8 m/seg<sub>2</sub>.",
					answer: "GRAVEDAD",
					position: 10,
					paintPos:3,
					orientation: "down",
					startx: 8,
					starty: 16
				},
				{
					clue: "Velocidad que depende de variación de posición de un objeto con movimiento ciruclar uniforme.",
					answer: "LINEAL",
					position: 11,
					paintPos:4,
					orientation: "down",
					startx: 11,
					starty: 11
				},
				{
					clue: "Velocidad que depende de la variación del ángulo con respecto al tiempo.",
					answer: "ANGULAR",
					position: 12,
					paintPos:5,
					orientation: "down",
					startx: 13,
					starty: 14
				},
				{
					clue: "Tiempo que demora un objeto en dar una vuelta.",
					answer: "PERIODO",
					position: 13,
					paintPos: 6,
					orientation: "down",
					startx: 15,
					starty: 10
				}
			] 
	
		$('#puzzle-wrapper').crossword(puzzleData);		
	})
	
})(jQuery)
});
