'use strict';

/**
 @author
A module representing the custom  html tags
@Module customTagManager  
**/
define([''], function() {
	


	var app = {};
	var _customTagList = [];
	var body = document.body;
	var html = body.innerHTML;

	function swapTag(findTagName, swapTagName, identifier) {
		if (document.querySelector(findTagName)) {
			identifier = identifier ? ' ' + identifier + ' ' : '';
			html = html
				.replace(new RegExp('<' + findTagName, 'g'), '<' + swapTagName + identifier)
				.replace(new RegExp('</' + findTagName + '>', 'g'), '</' + swapTagName + '>');
		}
	}

	app.replaceTagList = function() {


		_customTagList.forEach(function(o) {
			swapTag(o.customTagName, o.swapTagName, o.identifier);
		});

		/*************attr*************/
		//add custom attribute prefix : data-

		var sgAttrNameReg = /\ssg([\-][\w]*){1,5}(\s)?=/gi,
			s1 = html.split('<'),
			s2, matchArr, r2 = [],
			i;

		for (i = 0; i < s1.length; i++) {

			s2 = s1[i].split('>');
			//console.log(s2);
			for (var j = 0; j < s2.length; j++) {
				if (j % 2 == 0) {
					//console.log("s2", s2[j]);
					matchArr = s2[j].match(sgAttrNameReg);
					//console.log(matchArr);
					if (matchArr) {
						for (var k = 0; k < matchArr.length; k++) {
							//console.log(k, matchArr[k]);
							s2[j] = s2[j].replace(matchArr[k], " data-" + matchArr[k].substr(1));
						}
					}
				}
			}
			//console.log("s22",s2.join('>'));
			r2.push(s2.join('>'));
		}
		//console.log(r2.join('<'));
		html = r2.join('<');
		return html;

	};

	app.init = function() {

		function addCustomTag(customTagName, swapTagName, identifier) {
			_customTagList.push({
				customTagName: customTagName,
				swapTagName: swapTagName,
				identifier: identifier
			});
		}
		addCustomTag('sg-btn-hide', 'span', 'data-sg-id="btn-hide"');
		addCustomTag('sg-btn-popup-close', 'div', 'data-sg-id="btn-popup-close"');
		addCustomTag('sg-btn-popup', 'div', 'data-sg-id="btn-popup"');
		addCustomTag('sg-btn-page', 'div', 'data-sg-id="btn-page"');
		addCustomTag('sg-item-popup', 'div', 'data-sg-id="item-popup"');
		addCustomTag('sg-item-page', 'div', 'data-sg-id="item-page"');
		//New tags
		//Use with sg-hide
		addCustomTag('sg-btn-toggle', 'div', 'data-sg-id="btn-toggle"');

		//Tabs
		addCustomTag('sg-elem-tab','div','data-sg-id="elem-tab"');
		
		//Sequence
		addCustomTag('sg-elem-sequence', 'div', 'data-sg-id="elem-sequence"');
		addCustomTag('sg-btn-sequence', 'div', 'data-sg-id="btn-sequence"');
		addCustomTag('sg-item-sequence', 'div', 'data-sg-id="item-sequence"');


		// book elements 
		addCustomTag('sg-elem-book', 'div', 'data-sg-id="elem-book"');
		addCustomTag('sg-elem-page-book', 'div', 'data-sg-id="elem-page-book"');

		

		//Zoom-abled elements
		addCustomTag('sg-elem-zoom', 'div', 'data-sg-id="elem-zoom"');
		addCustomTag('sg-zoom-screen', 'div', 'data-sg-id="zoom-screen"');
		addCustomTag('sg-item-zoom', 'div', 'data-sg-id="item-zoom"');
		addCustomTag('sg-zoom-menu', 'div', 'data-sg-id="zoom-menu"');
		addCustomTag('sg-btn-zoom', 'div', 'data-sg-id="btn-zoom"');


		//lineJoin 

		addCustomTag('sg-elem-join-line', 'div', 'data-sg-id="elem-join-line"');
		addCustomTag('sg-item-line-init', 'div', 'data-sg-id="item-line-init"');
		addCustomTag('sg-item-line-target', 'div', 'data-sg-id="item-line-target"');

		//Game rain
		addCustomTag('sg-game-rain','div', 'data-sg-id="game-rain"');
		addCustomTag('sg-list-elems', 'div', 'data-sg-id="list-elems"');
		addCustomTag('sg-elem-rain', 'div', 'data-sg-id="elem-rain"');
		addCustomTag('sg-part-elem', 'div', 'data-sg-id="part-elem"');
		addCustomTag('sg-part-complete', 'div', 'data-sg-id="part-complete"');
		addCustomTag('sg-list-spinners', 'div', 'data-sg-id="list-spinners"');
		addCustomTag('sg-spinner', 'div', 'data-sg-id="spinner"');
		addCustomTag('sg-item-spinner', 'div', 'data-sg-id="item-spinner"');
		addCustomTag('sg-btn-game', 'div', 'data-sg-id="btn-game"');
		addCustomTag('sg-btn-check', 'div', 'data-sg-id="btn-check"');


		// TIC TAC TOE 
		addCustomTag('sg-game-tictactoe', 'div', 'data-sg-id="game-tictactoe"');
		addCustomTag('sg-btn-incorrect', 'button', 'data-sg-id="btn-incorrect"');
		addCustomTag('sg-btn-correct', 'button', 'data-sg-id="btn-correct"');


		// CHALLENGE / RETO

		addCustomTag('sg-game-challenge', 'div', 'data-sg-id="game-challenge"');
		addCustomTag('sg-game-item-level', 'div', 'data-sg-id="game-item-level"');
		addCustomTag('sg-game-item-question', 'div', 'data-sg-id="game-item-question"'); 
		addCustomTag('sg-game-item-quest', 'div', 'data-sg-id="game-item-quest"');
		addCustomTag('sg-game-item-option', 'button', 'data-sg-id="game-item-option"');
		addCustomTag('sg-game-item-anwser', 'button', 'data-sg-id="game-item-anwser"'); 
		addCustomTag('sg-btn-init', 'div', 'data-sg-id="btn-init"'); 


		// MATCH MEMORY CARDS
		addCustomTag('sg-game-matchmemory', 'div', 'data-sg-id="game-matchmemory"');


		// HANGMAN 
		addCustomTag('sg-game-hangman', 'div', 'data-sg-id="game-hangman"');
		addCustomTag('sg-word', 'div', 'data-sg-id="word"');

		 
	};

	app.init();

	return app;

});