 /*
    user strict 명령은 엄격하게 JavaScript 룰을 적용하라는 의미이다.
    일부 브라우저의 경우 use strict 명령을 통해 보다 빠르게 동작하는 경우도 존재하는 것 같다.
    잘못된 부분에 대한 검증도 보다 엄격하게 동작한다.
    하지만, 일부 라이브러리의 경우 use strict 명령을 사용하면 동작하지 않는 경우도 있으므로 주의해야 한다.
 */
 'use strict';
 /*
---custom tag and attribute list---
*
    sg-init
    sg-click
    sg-draggable
    sg-drop-selector
    sg-drop-success
    sg-drop-fail
sg-btn-dhide
    sg-onimg
    sg-swapimg
    sg-init
    sg-click
    sg-call
    sg-sound
    sg-key
sg-btn-hide
    sg-onimg
    sg-swapimg
    sg-init
    sg-click
    sg-call
    sg-sound
    sg-key
sg-btn-cover
    sg-onimg
    sg-swapimg
    sg-init
    sg-click
    sg-call
    sg-sound
    sg-key
sg-btn-popup
    sg-init
    sg-click
    sg-call
    sg-sound
    sg-key
sg-btn-page
    sg-init
    sg-click
    sg-call
    sg-sound
    sg-key
    sg-group

sg-item-page
    sg-init
    sg-call
    sg-sound
    sg-key
    sg-group
sg-item-popup
    sg-init
    sg-call
    sg-sound
    sg-key
--------------------
*/

 //--------------Require  configuration----------------------------------------------------

 var initList = initList || [];

 var sg = window.sg = sg || {};
 sg.relativeRootPath = sg.relativeRootPath || "../../common";
 sg.skinPath = sg.skinPath || "";
 window.location.hash = "";


 requirejs.config({
     //html파일 기준으로
     baseUrl: sg.relativeRootPath,
     waitSeconds: 10000,
     paths: {


         // crear un solo js con estos que sea el generic
         'text': 'lib/require/text', //HTML 데이터를 가져올때 text! 프리픽스를 붙여준다.
         'jquery': 'lib/jquery/jquery-1.11.1.min',
         'jquery-ui': 'lib/jquery/jquery-ui-1.10.4.custom.min', //jquery-ui-1.10.2.min',
         'jquery-ui-touchpunch': 'lib/jquery/jquery.ui.touch-punch.min',
         'jquery-regex': 'lib/jquery/jquery.regex',
         'jquery-scrollLock': 'lib/jquery/jquery.scrollLock',
         'jquery-ionsound': 'lib/jquery/ion.sound',
         'json': 'lib/json3/json3',
         'jquery-hittest': 'lib/jquery/e-smart-hittest-jquery',
         'jquery.countdown': 'lib/jquery/jquery.countdown360',
         //fin generic 
         'domReady': 'lib/require/domReady',



         //el que dependa de estos que los agregue en el define
         'jquery-drag': 'lib/jquery/jquery.event.drag-2.2',
         'jquery-easytabs': 'lib/jquery/jquery.easytabs.custom', //jquery.easytabs.min',
         //'jquery-fancybox': 'lib/jquery/fancybox/jquery.fancybox',
         //'jquery-cycle': 'lib/jquery/jquery.cycle2.min',
         'jquery-connectingLine': 'lib/jquery/jquery.connectingLine',
         'turnJs': 'lib/turnJs/turn',
         'zoomooz': 'lib/jquery/jquery.zoomooz',
         //'jquery-spin': 'lib/jquery/jquery.spin',
         //'angular': 'lib/angular/angular.min',
         //'spin': 'lib/utils/spin.min',


         'util': 'lib/tj/tj.utils',


         // estos se pueden agrupar en un archivo casi siempre se necesitan 
         'sgScaleScreen': 'js/modules/sgScaleScreen',
         'sgFunctions': 'js/modules/sgFunctions',
         'sgSlider': 'js/modules/sgSlider',
         'sgButtonsManager': 'js/modules/sgButtonsManager',
         'sgSound': 'js/modules/sgSound',
         'sgStylesCss': 'js/modules/sgStylesCss',
         'sgInstruction':'js/modules/sgInstruction',
         //'sgCustomCssManager': 'js/modules/sgCustomCssManager',


         'sgCustomTagManager': 'js/modules/sgCustomTagManager',

         // los modulos de los plugin nuevos estos dependen de la actividad y si el html los requiere
         'sgDraggable': 'js/modules/sgDraggable',
         'sgPopUp': 'js/modules/sgPopUp',
         'sgEasyTab': 'js/modules/sgEasyTab',
         'sgSequence': 'js/modules/sgSequence',
         'sgBook': 'js/modules/sgBook',
         'sgZoom': 'js/modules/sgZoom',
         'sgJoinLine': 'js/modules/sgJoinLine',
         'sgGameRain': 'js/modules/sgGameRain',
         'sgGameTictactoe': 'js/modules/sgGameTictactoe',
         'sgGameChallenge': 'js/modules/sgGameChallenge',
         'sgGameMatchMemory': 'js/modules/sgGameMatchMemory',
         'sgGameHangman': 'js/modules/sgGameHangman'



         //'progress': 'lib/progress/ProgressCircle.min'
     },

     /*
    shim:
    AMD 형식을 지원하지 않는 라이브러리의 경우 아래와 같이 SHIM을 사용해서 모듈로 불러올 수 있다.
    참고 : http://gregfranko.com/blog/require-dot-js-2-dot-0-shim-configuration/
*/
     shim: {

         // 'angular': {
         //     //deps:['jquery'],
         //     exports: 'angular'
         // },

         'jquery-regex': {
             deps: ['jquery']
         },
         'jquery-ui': {
             deps: ['jquery']
         },
         'jquery-ui-touchpunch': {
             deps: ['jquery-ui']
         },
         'jquery-drag': {
             deps: ['jquery', 'jquery-ui']
         },
         'jquery-hittest': {
             deps: ['jquery']
         },
         'zoomooz': {
             deps: ['jquery']
         },
         'jquery-easytabs': {
             deps: ['jquery']
         },
         'jquery-ionsound': {
             deps: ['jquery']
         },
         'sgScaleScreen': {
             deps: ['jquery', 'json', 'jquery-scrollLock']
         },
         'sgFunctions': {
             deps: ['jquery']
         },
         'sgSound': {
             deps: ['jquery']
         },
         'sgButtonsManager': {
             deps: ['jquery', 'sgSound']
         },
         'sgStylesCss': {
             deps: ['jquery']
         },
         'sgDraggable': {
             deps: ['jquery']
         },
         'sgPopUp': {
             deps: ['jquery', 'sgButtonsManager', 'sgSound']
         },
         'jquery-scrollLock': {
             deps: ['jquery']
         },
         'sgZoom': {
             deps: ['jquery', 'zoomooz']
         },
         'sgEasyTab': {
             deps: ['jquery']
         },
         'sgSequence': {
             deps: ['jquery', 'sgButtonsManager']
         },
         'sgBook': {
             deps: ['jquery', 'turnJs']
         },
         'sgGameRain': {
             deps: ['jquery', 'sgPopUp']
         },
         'sgGameTictactoe': {
             deps: ['jquery']
         },
         'sgGameChallenge': {
             deps: ['jquery', 'sgSound']
         },
         'sgGameMatchMemory': {
             deps: ['jquery', 'sgSound']
         },
         'sgGameHangman': {
             deps: ['jquery', 'sgSound']
         },
         'sgInstruction': {
             deps: ['jquery']
         }



     },
 });

 //-----------------------------------------------------------
 requirejs(['jquery', 'json', 'sgScaleScreen', 'util', 'sgFunctions', 'sgSlider', 'sgButtonsManager',
         'sgStylesCss', 'jquery-easytabs', 'sgDraggable', 'jquery-ui',
         'jquery-drag', 'sgCustomTagManager',
         'sgSequence', 'sgInstruction', 'jquery-scrollLock', 'jquery-ui-touchpunch', 
     ],
     function($, JSON3, sgScaleScreen, util, sgFunctions, sgSlider,
         sgButtonsManager, sgStylesCss, jqEasyTabs,
         sgDraggable, jqUi, jqDrag, sgCustomTagManager,
         sgSequence, sgInstruction) {

         var body = document.body;
         body.style.visibility = "hidden";
         var html = body.innerHTML;

         html = sgCustomTagManager.replaceTagList();
         body.innerHTML = html;

         /*************attr*************/
         body.style.visibility = "visible";
         ////end custom tag change for standard
         //add progress img
         var progressImg = new Image();
         progressImg.id = "progressImg";
         progressImg.src = sg.relativeRootPath + "/img/progress_circle.gif";
         progressImg.style.position = "fixed";
         progressImg.style.left = ((window.innerWidth - 32) * 0.5) + "px";
         progressImg.style.top = ((window.innerHeight - 32) * 0.5) + "px";
         document.body.appendChild(progressImg);


         window.isContLoaded = false;
         window.isDocReady = false;
         // Maybe the window is loaded but the document is not ready yet
         $(window).load(function() {
             window.isContLoaded = true;
             if (window.isDocReady) {
                 // alert('borró load');
                 $("#progressImg").remove();
                 $content.css("visibility", "visible");
             }
         });


         // Validate if the module is used in the html code 
         var moduForLoad = [];

         if ($("[data-sg-id=elem-join-line]").length > 0) {
             moduForLoad.push('sgJoinLine');
         }
         if ($("[data-sg-id=elem-tab]").length > 0) {
             moduForLoad.push('sgEasyTab');
         }
         if ($("[data-sg-id=elem-zoom]").length > 0) {
             moduForLoad.push('sgZoom');
         }
         if ($("[data-sg-id=elem-book]").length > 0) {
             moduForLoad.push('sgBook');
         }
         if ($("[data-sg-id=btn-popup]").length > 0) {
             moduForLoad.push('sgPopUp');
         }
         if ($("[data-sg-id=game-rain]").length > 0) {
             moduForLoad.push('sgGameRain');
         }
         if ($("[data-sg-id=game-tictactoe]").length > 0) {
             moduForLoad.push('sgGameTictactoe');
         }
         if ($("[data-sg-id=game-challenge]").length > 0) {
             moduForLoad.push('sgGameChallenge');
         }
         if ($("[data-sg-id=game-matchmemory]").length > 0) {
             moduForLoad.push('sgGameMatchMemory');
         }
         if ($("[data-sg-id=game-hangman]").length > 0) {
             moduForLoad.push('sgGameHangman');
         }

         // Aqui deberian ir popup y drag pero por un lado el drag se puede llamar desde js y no siempre hay un data-sg-id y por otro lado popup
         //me tiro error en L/L_G10_U01_L02/L_G10_U01_L02_01_01_01.html 
         // esta es mas o menos la idea que tengo para evitar todos estos llamados de red 

         console.log(moduForLoad);

         requirejs(moduForLoad, function() {
             $(document).ready(function() {

                 var JSON = JSON || JSON3;
                 var $body = window.$body = $("body");
                 var $stage = window.$stage = $("#stage");
                 var $content = window.$content = $("#content");
                 var $window = $(window);

                 sgScaleScreen.init($stage);

                 ////scale mode////
                 //scrollbar w,h 20
                 sg.zidx = 1;

                 sgSlider.init();
                 //     //---------------------------------------------클래스 이름 처리----------------------------------------
                 // sgStylesCss.js 
                 sgStylesCss.init();
                 //     ///////////////////////////////drag attr func/////////////////////
                 sg.setDraggable = sgDraggable.setDraggable;
                 sg.resetDraggable = sgDraggable.resetDraggable;
                 sg.destroyDraggable = sgDraggable.destroyDraggable;
                 sg.setDraggable("[data-sg-draggable]");

                 // popUp module
                 //sgPopUp.init();


                 //이전에 클릭들이 작동한후 작동하도록..이곳에.
                 //addEventListener를 사용하지않는한 이벤트 바인드순서로 정하자.
                 //sgButtonsManager
                 sgButtonsManager.init();


                 //sgEasyTab
                 //sgEasyTab.init();

                 //sgSequence
                 sgSequence.init();


                 //sgBook  
                 //sgBook.init();

                 //sgZoom
                 //sgZoom.init();

                 sgInstruction.init();

                 // load only the modules those are necesaries in the current activity
                 var len = moduForLoad.length;
                 for (var i = 0; i < len; i++) {
                     var modul = require(moduForLoad[i]);
                     modul.init();
                 }



                 //     /////////////// html 에서 작성된 init();
                 if (window.init) {
                     //console.log(window.init);
                     window.init();
                 }
                 //다른 스크립트에서 등록한 초기화 내용들이 있다면 수행
                 if (window.initList) {
                     for (var fo in window.initList) {
                         window.initList[fo]();
                     }
                 }

                 //init함수 먼저 실행후에 디스패치
                 // setTimeout(function() {
                 //     $window.trigger("init");
                 // }, 0);

                 sgScaleScreen.init($stage);


                 if (window.ready) {
                     //console.log(window.init);
                     console.log(window.ready);
                     window.ready();
                 }

                 $.scrollLock(true);


                 // Maybe the document is ready but not the images from the content haven't been loaded
                 window.isDocReady = true;
                 if (window.isContLoaded) {
                     // alert('borró load');
                     $("#progressImg").remove();
                     $content.css("visibility", "visible");
                 }

                 setInterval(function() {
                     $("#progressImg").remove();
                     $content.css("visibility", "visible");
                 }, 1000);
             }) // end document ready 
         }); // end internal require 
     }); // end general require