var initList = initList || [];
initList.push(function() {

	$('.previous-button').html('').addClass('btn-hover');
	$('.next-button').html('').addClass('btn-hover');

	$('.btnCheck').css('opacity','0.5');

	$('.molecules').find('.molecule').each(function(index, value) {
		var dropSelector = $(value).attr('data-sg-drop-selector');
		sg.setDraggable($(value), {
			revert: false,
			dropSelector: dropSelector,
			success: function() {

				var $this = $(this);
				$this.addClass('ui-draggable-dragging');
				var drop = $this.data("hit").eq(0);
				var molecule = '';
				$this.hasClass('h2o')? drop.children().eq(0).show(): drop.children().eq(1).show();
				$this.css('display','none');

				$this.attr("data-sg-selected", ("#" + drop.attr("id")));
				drop.attr("id", (drop.attr("id") + "_fill"));

				var boton = $(".btnCheck");
				var attempts = parseInt(boton.attr("data-sg-count")) + 1;
				boton.attr("data-sg-count", attempts);
				if (attempts == 14) {
					boton.bind("click", revisar).addClass("ready btn-hover");
					boton.css('cursor', 'pointer');
					boton.css('opacity','1');
				}
				sg.sound('success-low');
			}
		});
	});

	function revisar() {
		var boton = $(".btnCheck");
		var right = false;
		var hg = $('.ui-draggable-dragging.hg').size();

		if ((hg > 0) && (hg < 3)) {
			right = true;
		} else {
			$('.ui-draggable-dragging').each(function() {
				$this = $(this);
				var selected = $this.attr("data-sg-selected");
				var elem_selected = $(selected + "_fill");
				var new_id = selected.replace(/_fill/g, '').replace(/#/g, '');
				elem_selected.attr("id", new_id);
				var id_drag = "#" + $this.attr("id");
				$(id_drag).css("visibility", "visible");
				$this.css("display", "none").remove();
				var attempts = parseInt(boton.attr("data-sg-count")) - 1;
				boton.attr("data-sg-count", attempts).removeClass("ready btn-hover").unbind("click", revisar);
				boton.css('cursor', 'default');
				boton.css('opacity','0.5');

			});
			$('.targets').children().each(function(){
				var $this = $(this);
				$this.children().hide();
			})
			if(hg==0){
				$('.btn_popup1').click();
				$('[data-sg-id=popupBg]').click(function(){
					$('[data-sg-id=item-popup][data-sg-key=1] .icon_close_button').click();
				}).css('cursor','pointer');
			}
			if(hg==14){
				$('.btn_popup2').click();
				$('[data-sg-id=popupBg]').click(function(){
					$('[data-sg-id=item-popup][data-sg-key=2] .icon_close_button').click();
				}).css('cursor','pointer');
			}
			if(hg>2 && hg!=14){
				$('.btn_popup3').click();
				$('[data-sg-id=popupBg]').click(function(){
					$('[data-sg-id=item-popup][data-sg-key=3] .icon_close_button').click();
				}).css('cursor','pointer');
			}
			sg.sound('error');
		}

		if (right) {
			boton.addClass('finished').removeClass('btn-hover');
			boton.unbind("click", revisar);
			boton.css('cursor', 'default');
			boton.css('opacity', '0.5');
			$('.molecule.h2o').removeClass('btn-hover').unbind('click');
			$('.molecule.hg').removeClass('btn-hover').unbind('click');
			sg.sound('success');
		}
	}

	sg.check1 = function(){
		var active = $('.activity1').find('.check.active').size();
		if(active==2){
			sg.sound('success');
			var offset = $('.activity2').css('top');
    		$('.wrap').animate({scrollTop: offset}, 1000);
    		$('.activity1 .check').unbind('click').css('cursor', 'default');
    		$('.activity1 .check_button').unbind('click').css({
    			'cursor': 'default',
    			'opacity': '0.5'
    		}).removeClass('btn-hover');
		}else{
			sg.sound('error');
		}
	}

	sg.check2 = function(){
		var active = $('.activity2').find('.check.c2.active').size() - $('.activity2').find('.check.c1.active').size();
		if(active==1){
			sg.sound('success');
			var offset = $('.activity3').css('top');
			$('.wrap').animate({scrollTop: offset}, 1000);
    		$('.activity2 .check').unbind('click').css('cursor', 'default');
    		$('.activity2 .check_button').unbind('click').css({
    			'cursor': 'default',
    			'opacity': '0.5'
    		}).removeClass('btn-hover');
		}else{
			sg.sound('error');
		}
	}
});