var initList = initList || [];
initList.push(function() {

    $('.options').find('.option').each(function(index, value) {
      var dropSelector= $(value).attr('data-sg-drop-selector');
      sg.setDraggable($(value), {
        revert: true,
        dropSelector:dropSelector,
        success: function() {
            
            var $this = $(this);
            var drop = $this.data("hit").eq(0);                    

            $this.attr( "data-sg-selected", ("#" + drop.attr("id")) );
            drop.attr("id", (drop.attr("id")+"_fill") );/*si cambio el id no aceptaría ninguno más*/
            $this.removeAttr("style");
            $this.addClass("drag-used");
            drop.append($this);

            var boton = $(".btnCheck");
            var attempts = parseInt(boton.attr("data-sg-count")) + 1;
            boton.attr("data-sg-count", attempts);
            if (attempts == 11) {
                boton.bind("click", revisar).addClass("ready btn-hover");
                boton.css('cursor','pointer');
            }
            sg.sound('success-low');
        },
        fail: function() {
        }
      });
    });

	function revisar(){
        var boton = $(".btnCheck");
        var num_corrects = 0;

        $('.drag-used').each(function() {
            $this = $(this);
            var correct = $this.attr("data-sg-correct");
            var selected = $this.attr("data-sg-selected");

            if(correct === selected){
                $this.addClass("correct").removeClass('btn-hover');
                num_corrects++;
            }else{
            	var elem_selected = $(selected+"_fill");
                var new_id = selected.replace('_fill','').replace('#','');
                elem_selected.attr("id",new_id);

                var id_drag = "#"+ $this.attr("id");
                $this.css("display", "none").remove();
                $(id_drag).css("visibility","visible");
            }
        });

        boton.attr("data-sg-count", num_corrects );
        if (num_corrects === 11)
        {
   			$("div[data-sg-id='btn-popup'][data-sg-key='1']").click();
   			boton.removeClass('ready').unbind("click", revisar);
            sg.sound('claps');
        }else{
            $("div[data-sg-id='btn-popup'][data-sg-key='2']").click();
          	boton.removeClass('ready').unbind("click", revisar);
        }
    }
});