'use strict';

/**
 *@author Felipe Vargas South RIC
 *A module representing the jquery easy-tab
 *@Module sgEasyTab
 */
define(['jquery', 'jquery-easytabs'], function($) {


	var app = {};

	function cssStylesTabs(tipo) {

		switch (tipo) {
			case "over_content":
				return {
					"position": "absolute",
					"top": "-15px"
				};
			default:
				return null;
		}
	}
	app.init = function() {

		var tabContainer = $("[data-sg-id=elem-tab]");

		// the tab wasn't declarated
		if (tabContainer.length == 0) return;



		var tabsContainer = tabContainer.find('.etabs');


		if (tabsContainer.length == 0) {
			console.error('sg-elem-tab: The element with class <etabs> does not exist');
			return;
		}


		var styleTab = tabContainer.attr('data-sg-tabs-style');



		tabsContainer.addClass(styleTab);

		if (tabsContainer.hasClass('icon_tab')) {

			var iconTab = tabsContainer.find('li a');

			iconTab.click(
				function() {
					iconTab.each(
						function() {
							$(this).find('.second').hide();
							$(this).find('.first').show();
						}
					)
					$(this).find('.second').show();
					$(this).find('.first').hide();

				}
			);

		}
		tabContainer.easytabs();

		//after to load the easy tab because is necesary that the element has the class active
		if (tabsContainer.hasClass('icon_tab')) {
			iconTab.each(
				function() {
						if ($(this).hasClass("active")) {
							$(this).find('.second').show();
							$(this).find('.first').hide();
						} else {
							$(this).find('.second').hide();
							$(this).find('.first').show();
						}
					
				}
			)
		}



	}
	return app;

})